
"use client";

import { SectionWrapper } from "@/components/SectionWrapper";
import { Card, CardContent, CardHeader, CardTitle, CardDescription } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import Link from "next/link";
import { personalInfo } from "@/lib/data";
import { Mail, Trash2 } from "lucide-react";

export default function DataDeletionPage() {
  const contactEmail = personalInfo.email;
  const siteName = personalInfo.name; // Or a more general site name if preferred

  return (
    <SectionWrapper
      id="data-deletion"
      title="Data Deletion Request"
      subtitle={`Your privacy is important to us at ${siteName}.`}
      containerClassName="container mx-auto px-4 sm:px-6 lg:px-8 py-12 md:py-16"
    >
      <Card className="max-w-3xl mx-auto shadow-lg">
        <CardHeader>
          <CardTitle className="text-2xl flex items-center">
            <Trash2 className="mr-2 h-6 w-6 text-primary" />
            Requesting Deletion of Your Personal Data
          </CardTitle>
          <CardDescription>
            You have the right to request the deletion of your personal data that we hold. Please follow the instructions below to submit your request.
          </CardDescription>
        </CardHeader>
        <CardContent className="space-y-6 text-muted-foreground">
          <section>
            <h2 className="text-xl font-semibold text-foreground mb-2">What Data We Hold</h2>
            <p>
              We may collect and store personal data when you interact with our services, such as when you:
            </p>
            <ul className="list-disc list-inside ml-4 my-2 space-y-1">
              <li>Register for an account (if applicable).</li>
              <li>Submit comments on our blog posts.</li>
              <li>Contact us through our contact form.</li>
              <li>Subscribe to our newsletter (if applicable).</li>
            </ul>
            <p>
              This data may include your name, email address, IP address, comments, and any other information you voluntarily provide.
            </p>
          </section>

          <section>
            <h2 className="text-xl font-semibold text-foreground mb-2">How to Request Data Deletion</h2>
            <p>
              To request the deletion of your personal data, please send an email to our support team at:
            </p>
            <div className="my-4 text-center">
              <Button asChild variant="outline" size="lg">
                <a href={`mailto:${contactEmail}?subject=Data Deletion Request - ${siteName}`}>
                  <Mail className="mr-2 h-5 w-5" /> {contactEmail}
                </a>
              </Button>
            </div>
            <p>
              In your email, please include the following information to help us identify your data:
            </p>
            <ul className="list-disc list-inside ml-4 my-2 space-y-1">
              <li>Your full name.</li>
              <li>The email address associated with your account or interactions.</li>
              <li>Any specific details that can help us locate your data (e.g., dates of comments, approximate registration date).</li>
              <li>A clear statement that you are requesting the deletion of your personal data.</li>
            </ul>
          </section>

          <section>
            <h2 className="text-xl font-semibold text-foreground mb-2">Verification Process</h2>
            <p>
              For security reasons and to protect your privacy, we may need to verify your identity before processing your data deletion request. We may contact you to request additional information to confirm your identity.
            </p>
          </section>

          <section>
            <h2 className="text-xl font-semibold text-foreground mb-2">Processing Your Request</h2>
            <p>
              Once your identity is verified, we will process your request within a reasonable timeframe, typically within 30 days, unless legal or operational reasons require us to retain certain information. We will inform you if we are unable to fully comply with your request and the reasons why.
            </p>
            <p className="mt-2">
              Please note that deleting your data is irreversible. Some anonymized or aggregated data that does not personally identify you may be retained for analytical purposes. Additionally, we may be required to retain certain information by law or for legitimate business purposes (e.g., for fraud prevention or to comply with legal obligations).
            </p>
          </section>

          <section>
            <h2 className="text-xl font-semibold text-foreground mb-2">Contact Us</h2>
            <p>
              If you have any questions about our data deletion process or your personal data, please do not hesitate to contact us at <a href={`mailto:${contactEmail}`} className="text-primary hover:underline">{contactEmail}</a>.
            </p>
          </section>
          <div className="mt-8 text-center">
            <Link href="/">
              <Button variant="link">Back to Home</Button>
            </Link>
          </div>
        </CardContent>
      </Card>
    </SectionWrapper>
  );
}
