// src/app/error.tsx
'use client';

import { useEffect } from 'react';
import { motion } from 'framer-motion';
import { AlertTriangle, RefreshCcw, Home } from 'lucide-react';
import { Button } from '@/components/ui/button';

export default function GlobalError({
  error,
  reset,
}: {
  error: Error & { digest?: string };
  reset: () => void;
}) {
  useEffect(() => {
    // Log the error to an error reporting service
    console.error("Global Error Boundary Caught:", error);
  }, [error]);

  return (
    <div className="flex flex-col items-center justify-center min-h-screen bg-background text-foreground p-6 text-center">
      <motion.div
        initial={{ opacity: 0, y: -50, scale: 0.5 }}
        animate={{ opacity: 1, y: 0, scale: 1 }}
        transition={{ duration: 0.5, type: 'spring', stiffness: 120 }}
        className="mb-8"
      >
        <AlertTriangle className="w-32 h-32 text-destructive" />
      </motion.div>
      <motion.h1
        initial={{ opacity: 0, y: 20 }}
        animate={{ opacity: 1, y: 0 }}
        transition={{ duration: 0.5, delay: 0.2 }}
        className="text-4xl md:text-5xl font-extrabold text-destructive mb-4"
      >
        Something Went Wrong
      </motion.h1>
      <motion.p
        initial={{ opacity: 0, y: 20 }}
        animate={{ opacity: 1, y: 0 }}
        transition={{ duration: 0.5, delay: 0.4 }}
        className="text-lg text-muted-foreground mb-10 max-w-md"
      >
        We apologize for the inconvenience. An unexpected error occurred.
        You can try to refresh the page or go back to the homepage.
      </motion.p>
      <motion.div
        initial={{ opacity: 0, scale: 0.8 }}
        animate={{ opacity: 1, scale: 1 }}
        transition={{ duration: 0.5, delay: 0.6 }}
        className="flex flex-col sm:flex-row gap-4"
      >
        <Button
          size="lg"
          variant="destructive"
          onClick={() => reset()}
        >
          <RefreshCcw className="mr-2 h-5 w-5" />
          Try Again
        </Button>
        <Button
          size="lg"
          variant="outline"
          onClick={() => window.location.href = '/'} 
        >
          <Home className="mr-2 h-5 w-5" />
          Go Back Home
        </Button>
      </motion.div>
      
      <div className="hero-bubbles-container pointer-events-none fixed inset-0 -z-10 overflow-hidden">
        <div className="bubble bubble-1" style={{ animationDelay: '0s, -1s', width: '30vw', height: '30vw', left: '15%', top: '25%', opacity: 0.08, background: 'linear-gradient(45deg, hsl(var(--destructive)), hsl(var(--accent)), hsl(var(--destructive)))' }}></div>
        <div className="bubble bubble-2" style={{ animationDelay: '-2s, -3s', width: '20vw', height: '20vw', left: '75%', top: '15%', opacity: 0.06, background: 'linear-gradient(45deg, hsl(var(--destructive)), hsl(var(--accent)), hsl(var(--destructive)))' }}></div>
        <div className="bubble bubble-3" style={{ animationDelay: '-4s, -5s', width: '25vw', height: '25vw', left: '35%', top: '75%', opacity: 0.07, background: 'linear-gradient(45deg, hsl(var(--destructive)), hsl(var(--accent)), hsl(var(--destructive)))' }}></div>
      </div>
    </div>
  );
}
