// src/app/not-found.tsx
'use client';

import Link from 'next/link';
import { motion } from 'framer-motion';
import { Frown, Home } from 'lucide-react';
import { Button } from '@/components/ui/button';

export default function NotFound() {
  return (
    <div className="flex flex-col items-center justify-center min-h-screen bg-background text-foreground p-6 text-center">
      <motion.div
        initial={{ opacity: 0, y: -50, scale: 0.5 }}
        animate={{ opacity: 1, y: 0, scale: 1 }}
        transition={{ duration: 0.5, type: 'spring', stiffness: 120 }}
        className="mb-8"
      >
        <Frown className="w-32 h-32 text-primary" />
      </motion.div>
      <motion.h1
        initial={{ opacity: 0, y: 20 }}
        animate={{ opacity: 1, y: 0 }}
        transition={{ duration: 0.5, delay: 0.2 }}
        className="text-8xl md:text-9xl font-extrabold text-primary mb-4"
      >
        404
      </motion.h1>
      <motion.p
        initial={{ opacity: 0, y: 20 }}
        animate={{ opacity: 1, y: 0 }}
        transition={{ duration: 0.5, delay: 0.4 }}
        className="text-2xl md:text-3xl font-semibold text-foreground mb-6"
      >
        Oops! Page Not Found
      </motion.p>
      <motion.p
        initial={{ opacity: 0, y: 20 }}
        animate={{ opacity: 1, y: 0 }}
        transition={{ duration: 0.5, delay: 0.6 }}
        className="text-lg text-muted-foreground mb-10 max-w-md"
      >
        It seems the page you were looking for doesn't exist or has been moved.
        Let's get you back on track.
      </motion.p>
      <motion.div
        initial={{ opacity: 0, scale: 0.8 }}
        animate={{ opacity: 1, scale: 1 }}
        transition={{ duration: 0.5, delay: 0.8 }}
      >
        <Link href="/">
          <Button size="lg" className="bg-primary hover:bg-primary/90 text-primary-foreground">
            <Home className="mr-2 h-5 w-5" />
            Go Back Home
          </Button>
        </Link>
      </motion.div>

      <div className="hero-bubbles-container pointer-events-none fixed inset-0 -z-10 overflow-hidden">
        <div className="bubble bubble-1" style={{ animationDelay: '0s, -2s', width: '30vw', height: '30vw', left: '10%', top: '20%', opacity: 0.1 }}></div>
        <div className="bubble bubble-2" style={{ animationDelay: '-3s, -4s', width: '20vw', height: '20vw', left: '70%', top: '10%', opacity: 0.08 }}></div>
        <div className="bubble bubble-3" style={{ animationDelay: '-6s, -6s', width: '25vw', height: '25vw', left: '30%', top: '70%', opacity: 0.09 }}></div>
        <div className="bubble bubble-4" style={{ animationDelay: '-1s, -1s', width: '15vw', height: '15vw', left: '80%', top: '80%', opacity: 0.07 }}></div>
      </div>
    </div>
  );
}
