
"use client";

import { SectionWrapper } from "@/components/SectionWrapper";
import { Card, CardContent, CardHeader, CardTitle, CardDescription } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import Link from "next/link";
import { personalInfo } from "@/lib/data";
import { ShieldCheck } from "lucide-react";

export default function PrivacyPolicyPage() {
  const siteName = personalInfo.name; // Or a general site name
  const siteUrl = personalInfo.siteUrl;
  const contactEmail = personalInfo.email;
  const lastUpdated = "October 26, 2023"; // CHANGE THIS DATE
  // const companyName = "[Your Company Name, if applicable, or Your Name]"; // Placeholder

  return (
    <SectionWrapper
      id="privacy-policy"
      title="Privacy Policy"
      subtitle={`How ${siteName} handles your information.`}
      containerClassName="container mx-auto px-4 sm:px-6 lg:px-8 py-12 md:py-16"
    >
      <Card className="max-w-3xl mx-auto shadow-lg">
        <CardHeader>
          <CardTitle className="text-2xl flex items-center">
            <ShieldCheck className="mr-2 h-6 w-6 text-primary" />
            Privacy Policy
          </CardTitle>
          <CardDescription>Last Updated: {lastUpdated}</CardDescription>
        </CardHeader>
        <CardContent className="space-y-6 text-sm text-muted-foreground">
          <p>
            {siteName} (&quot;we,&quot; &quot;us,&quot; or &quot;our&quot;) operates the website {siteUrl} (the &quot;Service&quot;). This page informs you of our policies regarding the collection, use, and disclosure of personal data when you use our Service and the choices you have associated with that data.
          </p>
          <p>
            We use your data to provide and improve the Service. By using the Service, you agree to the collection and use of information in accordance with this policy.
          </p>

          <section>
            <h2 className="text-lg font-semibold text-foreground mb-2">1. Information Collection and Use</h2>
            <p>We collect several different types of information for various purposes to provide and improve our Service to you.</p>
            <h3 className="text-md font-semibold text-foreground mt-3 mb-1">Types of Data Collected:</h3>
            <ul className="list-disc list-inside ml-4 space-y-1">
              <li>
                <strong>Personal Data:</strong> While using our Service, we may ask you to provide us with certain personally identifiable information that can be used to contact or identify you (&quot;Personal Data&quot;). Personally identifiable information may include, but is not limited to:
                <ul className="list-circle list-inside ml-6 mt-1 space-y-0.5">
                  <li>Email address (e.g., for comments, contact form, newsletter)</li>
                  <li>First name and last name (e.g., for comments, contact form)</li>
                  <li>Cookies and Usage Data</li>
                </ul>
              </li>
              <li>
                <strong>Usage Data:</strong> We may also collect information on how the Service is accessed and used (&quot;Usage Data&quot;). This Usage Data may include information such as your computer&apos;s Internet Protocol address (e.g. IP address), browser type, browser version, the pages of our Service that you visit, the time and date of your visit, the time spent on those pages, unique device identifiers and other diagnostic data.
              </li>
              <li>
                <strong>Tracking & Cookies Data:</strong> We use cookies and similar tracking technologies to track the activity on our Service and hold certain information. Cookies are files with small amounts of data which may include an anonymous unique identifier. You can instruct your browser to refuse all cookies or to indicate when a cookie is being sent. However, if you do not accept cookies, you may not be able to use some portions of our Service.
              </li>
            </ul>
          </section>

          <section>
            <h2 className="text-lg font-semibold text-foreground mb-2">2. Use of Data</h2>
            <p>{siteName} uses the collected data for various purposes:</p>
            <ul className="list-disc list-inside ml-4 space-y-1">
              <li>To provide and maintain our Service</li>
              <li>To notify you about changes to our Service</li>
              <li>To allow you to participate in interactive features of our Service when you choose to do so (e.g., blog comments)</li>
              <li>To provide customer support</li>
              <li>To gather analysis or valuable information so that we can improve our Service</li>
              <li>To monitor the usage of our Service</li>
              <li>To detect, prevent and address technical issues</li>
              <li>To provide you with news, special offers and general information about other goods, services and events which we offer that are similar to those that you have already purchased or enquired about unless you have opted not to receive such information (if applicable).</li>
            </ul>
          </section>

          <section>
            <h2 className="text-lg font-semibold text-foreground mb-2">3. Legal Basis for Processing Personal Data (GDPR)</h2>
            <p>If you are from the European Economic Area (EEA), {siteName}&apos;s legal basis for collecting and using the personal information described in this Privacy Policy depends on the Personal Data we collect and the specific context in which we collect it.</p>
             <p className="mt-1">{siteName} may process your Personal Data because:</p>
            <ul className="list-disc list-inside ml-4 space-y-1">
                <li>We need to perform a contract with you</li>
                <li>You have given us permission to do so</li>
                <li>The processing is in our legitimate interests and it is not overridden by your rights</li>
                <li>To comply with the law</li>
            </ul>
          </section>

          <section>
            <h2 className="text-lg font-semibold text-foreground mb-2">4. Data Retention</h2>
            <p>
              We will retain your Personal Data only for as long as is necessary for the purposes set out in this Privacy Policy. We will retain and use your Personal Data to the extent necessary to comply with our legal obligations (for example, if we are required to retain your data to comply with applicable laws), resolve disputes, and enforce our legal agreements and policies.
            </p>
          </section>

          <section>
            <h2 className="text-lg font-semibold text-foreground mb-2">5. Data Transfer</h2>
            <p>
              Your information, including Personal Data, may be transferred to — and maintained on — computers located outside of your state, province, country or other governmental jurisdiction where the data protection laws may differ from those from your jurisdiction.
            </p>
            <p className="mt-1">If you are located outside [Your Country, e.g., Norway] and choose to provide information to us, please note that we transfer the data, including Personal Data, to [Server Location Country, e.g., United States] and process it there.</p>
            <p className="mt-1">Your consent to this Privacy Policy followed by your submission of such information represents your agreement to that transfer.</p>
          </section>

          <section>
            <h2 className="text-lg font-semibold text-foreground mb-2">6. Disclosure of Data</h2>
            <p>We may disclose your Personal Data in the good faith belief that such action is necessary to:</p>
            <ul className="list-disc list-inside ml-4 space-y-1">
              <li>To comply with a legal obligation</li>
              <li>To protect and defend the rights or property of {siteName}</li>
              <li>To prevent or investigate possible wrongdoing in connection with the Service</li>
              <li>To protect the personal safety of users of the Service or the public</li>
              <li>To protect against legal liability</li>
            </ul>
          </section>

          <section>
            <h2 className="text-lg font-semibold text-foreground mb-2">7. Security of Data</h2>
            <p>
              The security of your data is important to us but remember that no method of transmission over the Internet or method of electronic storage is 100% secure. While we strive to use commercially acceptable means to protect your Personal Data, we cannot guarantee its absolute security.
            </p>
          </section>

          <section>
            <h2 className="text-lg font-semibold text-foreground mb-2">8. Your Data Protection Rights</h2>
            <p>Depending on your location, you may have the following data protection rights:</p>
            <ul className="list-disc list-inside ml-4 space-y-1">
              <li>The right to access, update or delete the information we have on you.</li>
              <li>The right of rectification.</li>
              <li>The right to object.</li>
              <li>The right of restriction.</li>
              <li>The right to data portability.</li>
              <li>The right to withdraw consent.</li>
            </ul>
            <p className="mt-1">Please visit our <Link href="/data-deletion" className="text-primary hover:underline">Data Deletion Request page</Link> for instructions on how to exercise some of these rights.</p>
          </section>
          
          <section>
            <h2 className="text-lg font-semibold text-foreground mb-2">9. Service Providers</h2>
            <p>
              We may employ third-party companies and individuals to facilitate our Service (&quot;Service Providers&quot;), provide the Service on our behalf, perform Service-related services or assist us in analyzing how our Service is used. These third parties have access to your Personal Data only to perform these tasks on our behalf and are obligated not to disclose or use it for any other purpose.
            </p>
            <h3 className="text-md font-semibold text-foreground mt-3 mb-1">Analytics (e.g., Google Analytics)</h3>
            <p>We may use third-party Service Providers to monitor and analyze the use of our Service. Google Analytics is a web analytics service offered by Google that tracks and reports website traffic. For more information on the privacy practices of Google, please visit the Google Privacy & Terms web page: <a href="https://policies.google.com/privacy?hl=en" target="_blank" rel="noopener noreferrer" className="text-primary hover:underline">https://policies.google.com/privacy</a></p>
            {/* Add other providers like AdSense, GTM if used and relevant for privacy */}
          </section>

          <section>
            <h2 className="text-lg font-semibold text-foreground mb-2">10. Children&apos;s Privacy</h2>
            <p>
              Our Service does not address anyone under the age of 13 (&quot;Children&quot;). We do not knowingly collect personally identifiable information from anyone under the age of 13. If you are a parent or guardian and you are aware that your Child has provided us with Personal Data, please contact us. If we become aware that we have collected Personal Data from children without verification of parental consent, we take steps to remove that information from our servers.
            </p>
          </section>

          <section>
            <h2 className="text-lg font-semibold text-foreground mb-2">11. Changes to This Privacy Policy</h2>
            <p>
              We may update our Privacy Policy from time to time. We will notify you of any changes by posting the new Privacy Policy on this page. We will let you know via email and/or a prominent notice on our Service, prior to the change becoming effective and update the &quot;last updated&quot; date at the top of this Privacy Policy. You are advised to review this Privacy Policy periodically for any changes.
            </p>
          </section>

          <section>
            <h2 className="text-lg font-semibold text-foreground mb-2">12. Contact Us</h2>
            <p>
              If you have any questions about this Privacy Policy, please contact us by email: <a href={`mailto:${contactEmail}`} className="text-primary hover:underline">{contactEmail}</a>.
            </p>
          </section>
          <div className="mt-8 text-center">
            <Link href="/">
              <Button variant="link">Back to Home</Button>
            </Link>
          </div>
        </CardContent>
      </Card>
    </SectionWrapper>
  );
}
