
"use client";

import { SectionWrapper } from "@/components/SectionWrapper";
import { Card, CardContent, CardHeader, CardTitle, CardDescription } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import Link from "next/link";
import { personalInfo } from "@/lib/data";
import { FileText } from "lucide-react";

export default function TermsOfServicePage() {
  const siteName = personalInfo.name; // Or a more general site name
  const siteUrl = personalInfo.siteUrl;
  const contactEmail = personalInfo.email;
  const lastUpdated = "October 26, 2023"; // CHANGE THIS DATE

  return (
    <SectionWrapper
      id="terms-of-service"
      title="Terms of Service"
      subtitle={`Please read these terms carefully before using ${siteName}.`}
      containerClassName="container mx-auto px-4 sm:px-6 lg:px-8 py-12 md:py-16"
    >
      <Card className="max-w-3xl mx-auto shadow-lg">
        <CardHeader>
          <CardTitle className="text-2xl flex items-center">
            <FileText className="mr-2 h-6 w-6 text-primary" />
            Terms of Service
          </CardTitle>
          <CardDescription>Last Updated: {lastUpdated}</CardDescription>
        </CardHeader>
        <CardContent className="space-y-6 text-sm text-muted-foreground">
          <p>
            Welcome to {siteName} (the &quot;Site&quot;), accessible at {siteUrl}. These Terms of Service (&quot;Terms&quot;) govern your use of our Site and services. By accessing or using the Site, you agree to be bound by these Terms. If you disagree with any part of the terms, then you may not access the Site.
          </p>

          <section>
            <h2 className="text-lg font-semibold text-foreground mb-2">1. Use of the Site</h2>
            <p>
              You agree to use the Site only for lawful purposes and in a way that does not infringe the rights of, restrict or inhibit anyone else&apos;s use and enjoyment of the Site. Prohibited behavior includes harassing or causing distress or inconvenience to any other user, transmitting obscene or offensive content, or disrupting the normal flow of dialogue within the Site.
            </p>
            <p className="mt-2">
              You must be at least 13 years old to use this Site. If you are under 18, you must have your parent or legal guardian’s permission to use the Site.
            </p>
          </section>

          <section>
            <h2 className="text-lg font-semibold text-foreground mb-2">2. Intellectual Property</h2>
            <p>
              All content published and made available on our Site is the property of {siteName} and the Site&apos;s creators. This includes, but is not limited to images, text, logos, documents, downloadable files and anything that contributes to the composition of our Site.
            </p>
            <p className="mt-2">
              You may view, download for caching purposes only, and print pages from the website for your own personal use, subject to the restrictions set out below and elsewhere in these terms and conditions.
            </p>
          </section>

          <section>
            <h2 className="text-lg font-semibold text-foreground mb-2">3. User Accounts (If Applicable)</h2>
            <p>
              If you create an account on our Site, you are responsible for maintaining the security of your account and you are fully responsible for all activities that occur under the account and any other actions taken in connection with it. We may suspend or terminate your account if you are found to be in breach of these Terms.
            </p>
          </section>

          <section>
            <h2 className="text-lg font-semibold text-foreground mb-2">4. User-Generated Content (e.g., Comments)</h2>
            <p>
              You grant {siteName} a non-exclusive, royalty-free, perpetual, and worldwide license to use, reproduce, modify, adapt, publish, translate, create derivative works from, distribute, and display any content you post or upload to the Site (e.g., blog comments) in any media.
            </p>
            <p className="mt-2">
              You are responsible for the content you post. You must not post any content that is illegal, offensive, or infringes on the rights of others. We reserve the right to remove any content we deem inappropriate.
            </p>
          </section>

          <section>
            <h2 className="text-lg font-semibold text-foreground mb-2">5. Links to Other Websites</h2>
            <p>
              Our Site may contain links to third-party websites or services that are not owned or controlled by {siteName}. We have no control over, and assume no responsibility for, the content, privacy policies, or practices of any third-party websites or services. You further acknowledge and agree that {siteName} shall not be responsible or liable, directly or indirectly, for any damage or loss caused or alleged to be caused by or in connection with the use of or reliance on any such content, goods or services available on or through any such websites or services.
            </p>
          </section>

          <section>
            <h2 className="text-lg font-semibold text-foreground mb-2">6. Disclaimer of Warranties</h2>
            <p>
              The Site is provided on an &quot;AS IS&quot; and &quot;AS AVAILABLE&quot; basis. {siteName} makes no warranties, expressed or implied, and hereby disclaims and negates all other warranties including, without limitation, implied warranties or conditions of merchantability, fitness for a particular purpose, or non-infringement of intellectual property or other violation of rights.
            </p>
          </section>

          <section>
            <h2 className="text-lg font-semibold text-foreground mb-2">7. Limitation of Liability</h2>
            <p>
              In no event shall {siteName} or its suppliers be liable for any damages (including, without limitation, damages for loss of data or profit, or due to business interruption) arising out of the use or inability to use the materials on {siteName}&apos;s Site, even if {siteName} or a {siteName} authorized representative has been notified orally or in writing of the possibility of such damage.
            </p>
          </section>

          <section>
            <h2 className="text-lg font-semibold text-foreground mb-2">8. Changes to These Terms</h2>
            <p>
              We reserve the right, at our sole discretion, to modify or replace these Terms at any time. If a revision is material, we will try to provide at least 30 days&apos; notice prior to any new terms taking effect. What constitutes a material change will be determined at our sole discretion. By continuing to access or use our Site after those revisions become effective, you agree to be bound by the revised terms.
            </p>
          </section>

          <section>
            <h2 className="text-lg font-semibold text-foreground mb-2">9. Governing Law</h2>
            <p>
              These Terms shall be governed and construed in accordance with the laws of [Your Country/State, e.g., Norway], without regard to its conflict of law provisions.
            </p>
          </section>

          <section>
            <h2 className="text-lg font-semibold text-foreground mb-2">10. Contact Us</h2>
            <p>
              If you have any questions about these Terms, please contact us at <a href={`mailto:${contactEmail}`} className="text-primary hover:underline">{contactEmail}</a>.
            </p>
          </section>
          <div className="mt-8 text-center">
            <Link href="/">
              <Button variant="link">Back to Home</Button>
            </Link>
          </div>
        </CardContent>
      </Card>
    </SectionWrapper>
  );
}
