
"use client";

import { useState, useEffect } from 'react';
import Link from 'next/link';
import { Button } from '@/components/ui/button';
import { Card, CardContent } from '@/components/ui/card';
import { Cookie } from 'lucide-react';

const COOKIE_CONSENT_KEY = 'cookie_consent_given';

export function CookieConsentBanner() {
  const [isVisible, setIsVisible] = useState(false);

  useEffect(() => {
    // This check ensures localStorage is only accessed on the client side
    // and the banner doesn't show if consent has already been given.
    if (localStorage.getItem(COOKIE_CONSENT_KEY) !== 'true') {
      setIsVisible(true);
    }
  }, []);

  const handleAccept = () => {
    localStorage.setItem(COOKIE_CONSENT_KEY, 'true');
    setIsVisible(false);
  };

  if (!isVisible) {
    return null;
  }

  return (
    <div className="fixed bottom-0 left-0 right-0 z-[100] p-4 sm:p-6 lg:p-8 animate-in slide-in-from-bottom-full duration-500">
      <Card className="max-w-4xl mx-auto shadow-2xl bg-card/95 backdrop-blur-sm">
        <CardContent className="flex flex-col sm:flex-row items-center justify-between gap-4 p-6">
          <div className="flex items-start gap-4">
            <Cookie className="h-6 w-6 sm:h-8 sm:w-8 text-primary flex-shrink-0 mt-1" />
            <div>
              <h3 className="font-semibold text-foreground">Our Use of Cookies</h3>
              <p className="text-sm text-muted-foreground mt-1">
                We use cookies and similar technologies to enhance your browsing experience,
                serve personalized ads or content, and analyze our traffic. By clicking "Accept", you
                consent to our use of cookies. Read our{' '}
                <Link href="/privacy-policy" className="underline hover:text-primary">
                  Privacy Policy
                </Link>
                {' '}for more details.
              </p>
            </div>
          </div>
          <Button onClick={handleAccept} className="w-full sm:w-auto flex-shrink-0">
            Accept
          </Button>
        </CardContent>
      </Card>
    </div>
  );
}
