
"use client";

import React from 'react';

const DuckIcon = (props: React.SVGProps<SVGSVGElement>) => (
  <svg
    viewBox="0 0 50 50"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
    {...props}
    // Increased size for better visibility
    style={{ width: '80px', height: '80px', ...props.style }}
  >
    <path
      d="M34.312 28.537c-1.385-2.65-3.69-4.58-6.43-5.32-2.74-.74-5.69-.27-8.15 1.28-2.46 1.55-4.32 3.99-5.18 6.78-.86 2.79-.7 5.86.48 8.41.25.53.53 1.05.85 1.54.32.49.68.96 1.07 1.41.39.45.82.87 1.28 1.27.46.4.95.77 1.47 1.11 2.58 1.7 5.83 2.15 8.78 1.25 2.95-.9 5.3-3.15 6.55-5.91.43-.96.67-1.99.72-3.03.05-1.04-.08-2.08-.4-3.06-.32-.98-.82-1.9-1.47-2.73z"
      fill="#FFD400"
    />
    <path
      d="M24.773 17.582c-1.54-3.09-4.5-5.26-7.93-5.7-3.43-.44-6.84.82-9.1 3.32-2.26 2.5-3.23 5.8-2.62 8.92.61 3.12 2.78 5.76 5.56 7.22"
      stroke="#FFD400"
      strokeWidth={2}
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M31.25 18.125a1.563 1.563 0 11-3.125 0 1.563 1.563 0 013.125 0z"
      fill="#1E1E1E"
    />
    <path
      d="M44.204 29.56c.89-2.07 1.2-4.32.89-6.52-.3-2.2-1.21-4.25-2.62-5.94-1.4-1.69-3.26-2.94-5.38-3.61-2.12-.67-4.41-.73-6.57-.16"
      stroke="#FFD400"
      strokeWidth={2}
      strokeLinecap="round"
      strokeLinejoin="round"
    />
  </svg>
);

const Bubble = ({ style }: { style: React.CSSProperties }) => (
  <div
    className="absolute rounded-full bg-white/20"
    style={style}
  ></div>
);

export function InitialLoadingScreen() {
  const duckAnimationConfig = [
    { swimDuration: '12s', bobDuration: '2.5s', delay: '0s', left: '10%' },
    { swimDuration: '15s', bobDuration: '2s', delay: '-7s', left: '30%' },
    { swimDuration: '10s', bobDuration: '3s', delay: '-2s', left: '50%' },
    { swimDuration: '14s', bobDuration: '2.2s', delay: '-10s', left: '70%' },
    { swimDuration: '11s', bobDuration: '2.8s', delay: '-4s', left: '90%' },
  ];

  return (
    <div className="fixed inset-0 z-[200] flex flex-col items-center justify-center bg-blue-500 overflow-hidden">
      <style>
        {`
          @keyframes swim {
            0% { transform: translateX(0vw) scaleX(1); }
            49% { transform: translateX(calc(100vw - 100px)) scaleX(1); }
            50% { transform: translateX(calc(100vw - 100px)) scaleX(-1); }
            99% { transform: translateX(0vw) scaleX(-1); }
            100% { transform: translateX(0vw) scaleX(1); }
          }
          @keyframes bob {
            0%, 100% { transform: translateY(0); }
            50% { transform: translateY(-15px); }
          }
          @keyframes rise {
            from { bottom: -50px; opacity: 0; }
            to { bottom: 100%; opacity: 1; }
          }
        `}
      </style>
      <div className="text-center text-white mb-16">
        <h1 className="text-4xl font-bold animate-pulse">Loading...</h1>
        <p className="text-lg mt-2">Getting things ready...</p>
      </div>

      {/* Water surface */}
      <div className="absolute bottom-0 left-0 right-0 h-1/2 bg-blue-600 z-10">
        <div className="absolute top-0 left-0 right-0 h-2 bg-white/30 -translate-y-1"></div>
        {/* Ducks */}
        {duckAnimationConfig.map((config, i) => (
          <div
            key={`swim-${i}`}
            className="duck-swim-container absolute bottom-1/2"
            style={{
              left: config.left,
              animationName: 'swim',
              animationDuration: config.swimDuration,
              animationTimingFunction: 'linear',
              animationIterationCount: 'infinite',
              animationDelay: config.delay,
            }}
          >
            <div
              className="duck-bob-container"
              style={{
                animationName: 'bob',
                animationDuration: config.bobDuration,
                animationTimingFunction: 'ease-in-out',
                animationIterationCount: 'infinite',
                animationDelay: config.delay,
              }}
            >
              <DuckIcon />
            </div>
          </div>
        ))}
      </div>

      {/* Bubbles */}
      <div className="absolute bottom-0 left-0 w-full h-1/2 overflow-hidden z-0">
        <Bubble style={{ width: 25, height: 25, left: '10%', animation: 'rise 10s infinite', animationDelay: '0s' }} />
        <Bubble style={{ width: 20, height: 20, left: '20%', animation: 'rise 7s infinite', animationDelay: '1s' }} />
        <Bubble style={{ width: 35, height: 35, left: '35%', animation: 'rise 12s infinite', animationDelay: '2s' }} />
        <Bubble style={{ width: 15, height: 15, left: '50%', animation: 'rise 6s infinite', animationDelay: '0s' }} />
        <Bubble style={{ width: 30, height: 30, left: '70%', animation: 'rise 15s infinite', animationDelay: '3s' }} />
        <Bubble style={{ width: 22, height: 22, left: '85%', animation: 'rise 8s infinite', animationDelay: '1s' }} />
      </div>
    </div>
  );
}
