
"use client";

import Link from 'next/link';
import { motion } from 'framer-motion';
import { Newspaper, UserSquare } from 'lucide-react';
import { personalInfo } from '@/lib/data';

interface SplashScreenProps {
  onChoiceMade: () => void;
}

export function SplashScreen({ onChoiceMade }: SplashScreenProps) {
  const splashSectionClasses = "relative flex-1 w-full md:w-1/2 h-1/2 md:h-full flex items-center justify-center text-white text-center overflow-hidden group cursor-pointer";
  const overlayClasses = "absolute inset-0 bg-black/60 group-hover:bg-black/40 transition-all duration-500 z-10";
  const contentClasses = "relative z-20 flex flex-col items-center p-4";
  const iframeClasses = "absolute inset-0 w-full h-full border-0 pointer-events-none transition-transform duration-500 ease-in-out group-hover:scale-110";

  return (
    <div className="fixed inset-0 z-[150] bg-background flex flex-col md:flex-row">
      {/* Resume Section */}
      <motion.div
        initial={{ y: '100vh', opacity: 0 }}
        animate={{ y: 0, opacity: 1 }}
        transition={{ duration: 0.7, delay: 0.2, ease: "circOut" }}
        className={splashSectionClasses}
      >
        <Link href="/" onClick={onChoiceMade} className="absolute inset-0 z-20" aria-label="Go to Resume">
          <div className={overlayClasses}></div>
          <div className={contentClasses}>
            <UserSquare className="w-16 h-16 mb-4" />
            <h2 className="text-3xl md:text-4xl font-bold">{personalInfo.name}'s Resume</h2>
            <p className="mt-2 text-lg">View my interactive resume</p>
          </div>
        </Link>
        <iframe
          src="/"
          className={iframeClasses}
          title="Resume Preview"
          sandbox="allow-scripts allow-same-origin"
        />
      </motion.div>

      {/* Blog Section */}
      <motion.div
        initial={{ y: '-100vh', opacity: 0 }}
        animate={{ y: 0, opacity: 1 }}
        transition={{ duration: 0.7, delay: 0.2, ease: "circOut" }}
        className={splashSectionClasses}
      >
        <Link href="/blog" onClick={onChoiceMade} className="absolute inset-0 z-20" aria-label="Go to Blog">
          <div className={overlayClasses}></div>
          <div className={contentClasses}>
            <Newspaper className="w-16 h-16 mb-4" />
            <h2 className="text-3xl md:text-4xl font-bold">My Blog</h2>
            <p className="mt-2 text-lg">Read my latest articles and insights</p>
          </div>
        </Link>
        <iframe
          src="/blog"
          className={iframeClasses}
          title="Blog Preview"
          sandbox="allow-scripts allow-same-origin"
        />
      </motion.div>
    </div>
  );
}
