
import { SectionWrapper } from "@/components/SectionWrapper";
import { personalInfo } from "@/lib/data";
import { Card, CardContent } from "@/components/ui/card";

export function AboutSection() {
  return (
    <SectionWrapper 
      id="about" 
      title="Professional Summary" // Title changed
    >
      <div className="max-w-3xl mx-auto"> {/* Centering content */}
        {/* Removed Image and grid layout */}
        <Card className="bg-card/80 dark:bg-card/60 backdrop-blur-sm shadow-xl p-2">
          <CardContent className="pt-6">
            <div className="text-lg md:text-xl leading-relaxed text-card-foreground/90 dark:text-card-foreground/80 space-y-4">
              {personalInfo.about.split('\n\n').map((paragraph, index) => ( // Split by double newline for paragraphs
                <p key={index} className="mb-4 last:mb-0">{paragraph}</p> // Use <p> for paragraphs
              ))}
            </div>
          </CardContent>
        </Card>
      </div>
    </SectionWrapper>
  );
}
