
"use client";

import Link from "next/link";
import Image from "next/image";
import { motion } from "framer-motion";
import { Button } from "@/components/ui/button";
import { personalInfo } from "@/lib/data";
import { ArrowDown, Mail, Phone as PhoneIcon, PhoneCall, MessageCircle } from "lucide-react";
import {
  DropdownMenu,
  DropdownMenuContent,
  DropdownMenuItem,
  DropdownMenuTrigger,
} from "@/components/ui/dropdown-menu";

export function HeroSection() {
  const monkeyImageUrl = "https://assets.zyrosite.com/cdn-cgi/image/format=auto,w=945,h=1064,fit=crop,trim=0;152.58969465648858;0;899.0419847328245/mP4eW5e5e0T0PkWW/pito-marketing-medico-AE0Mz2nDl1h8pBjX.png";

  const formatPhoneNumberForWhatsApp = (phone: string) => {
    // Removes all non-digit characters from the phone number
    return phone.replace(/\D/g, "");
  };

  const formattedWhatsAppNumber = formatPhoneNumberForWhatsApp(personalInfo.phone);

  return (
    <section
      id="hero"
      className="relative min-h-screen flex flex-col items-center justify-end pt-12 pb-0 md:pt-20 overflow-hidden bg-background"
      aria-labelledby="hero-heading"
    >
      {/* Background overlay & bubbles */}
      <div className="absolute inset-0 bg-black/60 z-0" aria-hidden="true"></div>
      <div className="hero-bubbles-container pointer-events-none" aria-hidden="true">
        <div className="bubble bubble-1"></div>
        <div className="bubble bubble-2"></div>
        <div className="bubble bubble-3"></div>
        <div className="bubble bubble-4"></div>
        <div className="bubble bubble-5"></div>
      </div>

      {/* Main Text Content Area */}
      <div className="container mx-auto px-4 sm:px-6 lg:px-8 text-center z-10 relative mb-auto"> {/* Changed z-20 to z-10 */}

        <motion.h1
          id="hero-heading"
          initial={{ opacity: 0, y: 20 }}
          animate={{ opacity: 1, y: 0 }}
          transition={{ duration: 0.8, delay: 0.2 }}
          className="text-4xl sm:text-5xl md:text-6xl font-extrabold mb-4 text-primary-foreground"
        >
          {personalInfo.name}
        </motion.h1>

        <motion.p
          initial={{ opacity: 0, y: 20 }}
          animate={{ opacity: 1, y: 0 }}
          transition={{ duration: 0.8, delay: 0.4 }}
          className="text-xl sm:text-2xl text-primary font-medium mb-6"
        >
          {personalInfo.title}
        </motion.p>

        <motion.div
          initial={{ opacity: 0, y: 20 }}
          animate={{ opacity: 1, y: 0 }}
          transition={{ duration: 0.8, delay: 0.6 }}
          className="flex flex-col sm:flex-row justify-center items-center space-y-2 sm:space-y-0 sm:space-x-6 mb-8 text-primary-foreground/80"
        >
          <a
            href={`mailto:${personalInfo.email}`}
            className="flex items-center hover:text-primary transition-colors"
            aria-label={`Email ${personalInfo.name} at ${personalInfo.email}`}
          >
            <Mail className="mr-2 h-5 w-5" aria-hidden="true" />
            {personalInfo.email}
          </a>

          <DropdownMenu>
            <DropdownMenuTrigger asChild>
              <button
                className="flex items-center hover:text-primary transition-colors"
                aria-label={`Contact ${personalInfo.name} by phone`}
              >
                <PhoneIcon className="mr-2 h-5 w-5" aria-hidden="true" />
                {personalInfo.phone}
              </button>
            </DropdownMenuTrigger>
            <DropdownMenuContent align="start" className="bg-background border-border shadow-xl">
              <DropdownMenuItem asChild>
                <a href={`tel:${personalInfo.phone}`} className="flex items-center w-full cursor-pointer text-foreground hover:bg-accent hover:text-accent-foreground p-2 rounded-md">
                  <PhoneCall className="mr-2 h-4 w-4" /> Call
                </a>
              </DropdownMenuItem>
              <DropdownMenuItem asChild>
                <a href={`https://wa.me/${formattedWhatsAppNumber}`} target="_blank" rel="noopener noreferrer" className="flex items-center w-full cursor-pointer text-foreground hover:bg-accent hover:text-accent-foreground p-2 rounded-md">
                  <MessageCircle className="mr-2 h-4 w-4" /> WhatsApp
                </a>
              </DropdownMenuItem>
            </DropdownMenuContent>
          </DropdownMenu>

        </motion.div>

        <motion.div
          initial={{ opacity: 0, y: 20 }}
          animate={{ opacity: 1, y: 0 }}
          transition={{ duration: 0.8, delay: 0.8 }}
        >
          <Link href="#about"
            onClick={(e) => {
              e.preventDefault();
              const aboutElement = document.getElementById('about');
              if (aboutElement) {
                aboutElement.scrollIntoView({ behavior: 'smooth' });
              }
            }}
            aria-label="Learn more about me, scroll to about section"
          >
            <Button variant="ghost" size="lg" className="rounded-full text-primary-foreground/80 hover:text-primary hover:bg-primary/10">
              Learn More <ArrowDown className="ml-2 h-5 w-5 animate-bounce" aria-hidden="true" />
            </Button>
          </Link>
        </motion.div>
      </div>

      {/* Monkey Image Container */}
      <motion.div
        initial={{ opacity: 0, y: 100 }}
        animate={{ opacity: 1, y: 0 }}
        transition={{ duration: 0.8, delay: 0.5, type: 'spring', stiffness: 50 }}
        className="w-full max-w-[280px] sm:max-w-[320px] md:max-w-[380px] lg:max-w-[420px] z-20 relative pointer-events-none" // Changed z-10 to z-20
      >
        {/* Aspect ratio container for the cropped monkey appearance (approx 945 width / 746 height) */}
        <div className="relative w-full" style={{ paddingTop: '78.99%' }}>
            <Image
                src={monkeyImageUrl}
                alt="Marketing character monkey"
                fill
                style={{ objectFit: 'cover' }} // This will crop the image to fit the container's aspect ratio
                className="object-center" // Vertically centers the cropped image
                data-ai-hint="monkey business suit"
                priority
            />
        </div>
      </motion.div>
    </section>
  );
}
