// src/lib/gtag.ts

// https://developers.google.com/analytics/devguides/collection/gtagjs/pages
export const pageview = (url: URL | string, trackingId: string) => {
  if (typeof window.gtag !== 'function') {
    console.warn("gtag function not found on window. Google Analytics may not be initialized correctly.");
    return;
  }
  window.gtag('config', trackingId, {
    page_path: url,
  });
};

// https://developers.google.com/analytics/devguides/collection/gtagjs/events
interface EventParams {
  action: string;
  category: string;
  label: string;
  value: number;
}

export const event = ({ action, category, label, value }: EventParams) => {
  if (typeof window.gtag !== 'function') {
    console.warn("gtag function not found on window. Google Analytics may not be initialized correctly.");
    return;
  }
  window.gtag('event', action, {
    event_category: category,
    event_label: label,
    value: value,
  });
};
